﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using SentenceParser;
using Parsing;

namespace SentenceParserApp
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private InlineSentenceParser theParser;

        private void btnParse_Click(object sender, EventArgs e)
        {
            if (theParser == null)
                theParser = new InlineSentenceParser();
            SentenceParser.SentenceParser parserInstance 
                = theParser.ParseSentence(txtInputSentence.Text);
            if (!string.IsNullOrEmpty(parserInstance.Errors))
                MessageBox.Show(this, parserInstance.Errors,
                    "Error in sentence", MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            else
            {
                string resultFormat =
                    "Present tense sentences: {0}\r\n" +
                    "Past tense sentences: {1}\r\n" +
                    "Plural sentences: {2}\r\n" +
                    "Singular sentences: {3}\r\n" +
                    "Total adjectives: {4}";

                string result = string.Format
                (
                    resultFormat,
                    parserInstance.PresentCount,
                    parserInstance.PastCount,
                    parserInstance.PluralCount,
                    parserInstance.SingularCount,
                    parserInstance.AdjectivesCount
                );

                MessageBox.Show(this, result, "Sentence Analysis",
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
                btnTables.Enabled = true;
            }
        }

        private void btnTables_Click(object sender, EventArgs e)
        {
            ViewTablesForm vtf = new ViewTablesForm();
            vtf.TableDescription = theParser.ParserStateTables;
            vtf.ShowDialog(this);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            textBox1.Select(0, 0);
        }
    }
}
