﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CalculatorDemo;

namespace CalculatorDemoApp
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Most buttons just cause their symbol to be added to the display
        /// </summary>
        /// <param name="sender">The button that was clicked</param>
        /// <param name="e">Unused</param>
        
        private void buttonCalcSymbolEntry_Click(object sender, EventArgs e)
        {
            txtCalcDisplay.Text += (sender as Button).Text;
        }

        /// <summary>
        /// The CE button clears the most recently entered character
        /// </summary>
        /// <param name="sender">The button that was clicked</param>
        /// <param name="e">Unused</param>
        
        private void buttonClearEntry_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(txtCalcDisplay.Text))
                txtCalcDisplay.Text = txtCalcDisplay.Text
                    .Substring(0, txtCalcDisplay.Text.Length - 1);
        }

        /// <summary>
        /// Clear the entire text box
        /// </summary>
        /// <param name="sender">The button that was clicked</param>
        /// <param name="e">Unused</param>

        private void buttonClear_Click(object sender, EventArgs e)
        {
            txtCalcDisplay.Text = string.Empty;
        }

        private string debugResults = string.Empty;

        /// <summary>
        /// The equals button runs the parser and calculates
        /// the result. The result is displayed back in the
        /// display text box.
        /// </summary>
        /// <param name="sender">The button that was clicked</param>
        /// <param name="e">Unused</param>

        private void buttonEquals_Click(object sender, EventArgs e)
        {
            if (lR1CalculatorToolStripMenuItem.Checked)
            {
                txtCalcDisplay.Text = Calculator.Calculate(txtCalcDisplay.Text);
                debugResults = Calculator.DebugResults;
            }
            else
            {
                txtCalcDisplay.Text = GLRCalculator.Calculate(txtCalcDisplay.Text);
                debugResults = GLRCalculator.DebugResults;
            }

            if (txtCalcDisplay.Text == "Error")
            {
                ReportForm rf = new ReportForm();
                rf.DisplayedText = Calculator.ErrorResults;
                rf.ShowDialog(this);
            }
        }

        private void lR1CalculatorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            lR1CalculatorToolStripMenuItem.Checked = true;
            gLRCalculatorToolStripMenuItem.Checked = false;
            Text = "LR(1) Calculator";
        }

        private void gLRCalculatorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            lR1CalculatorToolStripMenuItem.Checked = false;
            gLRCalculatorToolStripMenuItem.Checked = true;
            Text = "GLR Calculator";
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void viewParseInfoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ReportForm rf = new ReportForm();
            rf.DisplayedText = debugResults;
            rf.ShowDialog();
        }
    }
}
