﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrafficLightController
{
    public enum LightColour
    {
        RED,
        YELLOW,
        GREEN,
        REDANDYELLOW
    }

    /// <summary>
    /// Simple simulation of a traffic light
    /// </summary>
    
    public class TrafficLight
    {
        public TrafficLight()
        {
            Colour = LightColour.GREEN;
        }

        public event EventHandler PropertyChanged;

        private LightColour colour;
        public LightColour Colour
        {
            get
            {
                return colour;
            }
            set
            {
                colour = value;
                if (PropertyChanged != null)
                    PropertyChanged(this, EventArgs.Empty);
            }
        }

        public bool Red
        {
            get
            {
                return Colour == LightColour.RED || Colour == LightColour.REDANDYELLOW;
            }
        }

        public bool Yellow
        {
            get
            {
                return Colour == LightColour.REDANDYELLOW || Colour == LightColour.YELLOW;
            }
        }

        public bool Green
        {
            get
            {
                return Colour == LightColour.GREEN;
            }
        }
    }
}
