﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrafficLightController
{
    public class StopWalkIndicator
    {
        public event EventHandler PropertyChanged;

        public StopWalkIndicator()
        {
            CanWalk = false;
        }

        private bool buttonPressed;
        public bool ButtonPressed
        {
            get
            {
                return buttonPressed;
            }
            set
            {
                buttonPressed = value;
                if (PropertyChanged != null)
                    PropertyChanged(this, EventArgs.Empty);
            }
        }

        private bool canWalk;
        public bool CanWalk
        {
            get
            {
                return canWalk;
            }
            set
            {
                canWalk = value;
                if (PropertyChanged != null)
                    PropertyChanged(this, EventArgs.Empty);
            }
        }

        public bool Walk
        {
            get
            {
                return CanWalk;
            }
        }

        public bool Stop
        {
            get
            {
                return !CanWalk;
            }
        }
    }
}
