﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Parsing;
using ParserGenerator;
using System.IO;

namespace CalculatorDemo
{
    /// <summary>
    /// The user written part of the parser. The other
    /// is auto-generated by ParseLR.exe, and placed
    /// into Calculator.Designer.cs. The auto-generated
    /// part is actually a derived class from Calculator,
    /// in the namespace CalculatorDemo.AutoGenerated
    /// with class name CalculatorDemo_AutoGenerated.
    /// </summary>
    
    public class Calculator : Parser
    {
        /// <summary>
        /// Where the overall result of the
        /// calculated expression is stored.
        /// Alternatively filled in with the
        /// error information if badly formed.
        /// </summary>
        
        public string Result
        {
            get;
            protected set;
        }

        private static StringWriter errorResults;

        /// <summary>
        /// Get the error output from the parser
        /// </summary>
        
        public static string ErrorResults
        {
            get
            {
                return errorResults.ToString();
            }
        }

        private static StringWriter debugResults;

        /// <summary>
        /// Verbose output from parser
        /// </summary>
        
        public static string DebugResults
        {
            get
            {
                return debugResults.ToString();
            }
        }

        /// <summary>
        /// Given an arithmetic expression, parse it
        /// and compute the result.
        /// </summary>
        /// <param name="input">The expression string</param>
        /// <returns>A string representation of the result</returns>
        
        public static string Calculate(string input)
        {
            errorResults = new StringWriter();
            debugResults = new StringWriter();

            // Since the source code for the parser was
            // compiled offline and added to this project,
            // we use the parameterless constructor of the
            // ParserFactory to make it load the precompiled
            // factory.

            ParserFactory<Calculator> calculatorFactory
                = new ParserFactory<Calculator>();

            // Once we have the parser factory, all parser
            // instances are created using the same
            // factory method.

            Calculator calc = calculatorFactory.CreateInstance();

            calc.DebugStream = debugResults;
            calc.ErrStream = errorResults;
            CalculatorTokeniser tokeniser
                = new CalculatorTokeniser(input, calc.Tokens);
            bool success = calc.Parse(tokeniser);

            if (success)
                return calc.Result;
            else
                return "Error";
        }
    }
}
