// Demonstration of object creation and use
public class App {
    public static void ReportDrivable(Drivable v) {
        System.out.println("My vehicle is a " + v.GetMake());
        System.out.println(v.CalculateJourney(30));
    }

    public static void main(String[] args) throws Exception {
        Drivable myCar = new Vehicle("VW Golf", 120, 7.5, 56);
        ReportDrivable(myCar);

        Drivable myPlane = new JetPlane("Tornado Jet", 950, 1.5, 52000);
        ReportDrivable(myPlane);
        
        if(myCar.GetTopSpeed() > myPlane.GetTopSpeed()) {
            System.out.println("My " + myCar.GetMake() + " is fastest.");
        } else {
            System.out.println("My " + myPlane.GetMake() + " is fastest.");
        }
    }
}

