public class JetPlane implements Drivable {
    public JetPlane(String make, int topSpeed, double milesPerGallon, int maxAltitude) {
        this.make = make;
        this.topSpeed = topSpeed;
        this.milesPerGallon = milesPerGallon;
        this.maxAltitude = maxAltitude;
    }

    private String make;

    public String GetMake() {
        return make;
    }

    private int topSpeed;

    public int GetTopSpeed() {
        return topSpeed;
    }

    private int maxAltitude;

    public int GetMaxAltitude() {
        return maxAltitude;
    }

    private double milesPerGallon;

    public double GetMilesPerGallon() {
        return milesPerGallon;
    }

    public String CalculateJourney(double miles) {
        double timeTaken = miles / topSpeed;
        double fuelUsed = miles / milesPerGallon;
        return "The " + make  + " can travel "
            + miles + " miles in " + timeTaken * 60
            + " minutes at an altitude of " + maxAltitude
            + " feet, and uses " + fuelUsed + " gallons.";
    }
}
