import java.util.Scanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App {
    static ArrayList<String> getCars() {
        ArrayList<String> cars = new ArrayList<String>();
        cars.add("Trabant");
        cars.add("Ford");
        cars.add("Ferrari");
        cars.add("Mercedes");
        cars.add("VW");
        cars.add("Bugatti");
        return cars;
    }

    static ArrayList<Integer> getTopSpeeds() {
         ArrayList<Integer> topSpeeds = new ArrayList<Integer>();
        topSpeeds.add(45);
        topSpeeds.add(90);
        topSpeeds.add(210);
        topSpeeds.add(180);
        topSpeeds.add(120);
        topSpeeds.add(220);
        return topSpeeds;
    }

    static Map<String, Integer> getCarMap() {
        Map<String, Integer> carMap = new HashMap<String, Integer>();
        carMap.put("Trabant", 45);
        carMap.put("Ford", 90);
        carMap.put("Ferrari", 210);
        carMap.put("Mercedes", 180);
        carMap.put("VW", 120);
        carMap.put("Bugatti", 220);
        return carMap;
    }

    static void OutputFastestAndSlowest(String fastest, String slowest) {
        System.out.println("The fastest car is the " + fastest);
        System.out.println("The slowest car is the " + slowest);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> cars = getCars();
        ArrayList<Integer> topSpeeds = getTopSpeeds();  

        // ### Add your code to find the fastest and slowest cars here

        int fastest = 0;
        int slowest = 0;

        for(int i = 0; i < cars.size(); i++)
        {
            if(topSpeeds.get(i) > topSpeeds.get(fastest)) {
                fastest = i;
            }
            if(topSpeeds.get(i) < topSpeeds.get(slowest)) {
                slowest = i;
            }
        }

        OutputFastestAndSlowest(cars.get(fastest), cars.get(slowest);
    
        Map<String, Integer> carMap = getCarMap();

        int topSpeed = 0, bottomSpeed = Integer.MAX_VALUE;
        String fastCar = "", slowCar = "";

        for(String car : carMap.keySet()) {
            int carSpeed = carMap.get(car);
            if(carSpeed > topSpeed || fastCar == "") {
                fastCar = car;
                topSpeed = carSpeed;
            }
            if(carSpeed < bottomSpeed || slowCar == "") {
                slowCar = car;
                bottomSpeed = carSpeed;
            }
        }

        OutputFastestAndSlowest(fastCar, slowCar);
    }
}
