﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using SimpleInjector;
using SimpleInjector.Extensions;
using VersionLib;

namespace VersionLibTest
{
    [TestClass]
    public class VersionOfTest
    {
        IVersionOfFactory<string> vofs;
        IVersionOf<string> vos;

        [TestInitialize]
        public void Setup()
        {
            Container c = new Container();
            c.RegisterPackages();
            vofs = c.GetInstance<IVersionOfFactory<string>>();
            Assert.IsNotNull(vofs);
        }

        [TestMethod]
        public void CreationTest()
        {
            vos = vofs.Create(new DateTime(2013, 1, 1), "VALUE", false);
            Assert.IsNotNull(vos);
            Assert.AreEqual(2013, vos.Started.Year);
            Assert.AreEqual("VALUE", vos.Value);
        }

        [TestMethod]
        public void WhenTest()
        {
            vos = vofs.Create(new DateTime(2013, 1, 1));
            Assert.IsNotNull(vos);
            Assert.AreEqual(2013, vos.Started.Year);
            Assert.IsNull(vos.Value);
        }

        [TestMethod]
        public void ComparisonTest()
        {
            vos = vofs.Create(new DateTime(2013, 1, 1), "VALUE", false);
            Assert.IsNotNull(vos);
            Assert.AreEqual(2013, vos.Started.Year);
            IVersionOf<string> vow = vofs.Create(new DateTime(2013, 1, 1, 0, 0, 0, 1));
            Assert.IsNull(vow.Value);
            Assert.IsTrue(vow.CompareTo(vos) < 0);
        }
    }
}
