﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using SimpleInjector;
using SimpleInjector.Extensions;
using VersionLib;

namespace VersionLibTest
{
    [TestClass]
    public class KeyTest
    {
        IKeyFactory kf;

        [TestInitialize]
        public void Setup()
        {
            Container c = new Container();
            c.RegisterPackages();
            kf = c.GetInstance<IKeyFactory>();
            Assert.IsNotNull(kf);
        }
        [TestMethod]
        public void CreateTest()
        {
            IKeyWithValue<int> kwv = (IKeyWithValue<int>)kf.NewKey();
            Assert.AreEqual(1, kwv.Value);
        }

        [TestMethod]
        public void SecondKeyTest()
        {
            IKeyWithValue<int> kwv = (IKeyWithValue<int>)kf.NewKey();
            Assert.AreEqual(1, kwv.Value);
            IKeyWithValue<int> kwv2 = (IKeyWithValue<int>)kf.NewKey();
            Assert.AreEqual(2, kwv2.Value);
        }

        [TestMethod]
        public void RegisterKeysTest()
        {
            IKey[] keys1 = new IKey[]
            {
                kf.NewKey(), kf.NewKey(), kf.NewKey()
            };
            IKey[] keys2 = new IKey[]
            {
                kf.NewKey(), kf.NewKey(), kf.NewKey()
            };

            Container c = new Container();
            c.RegisterPackages();

            kf = c.GetInstance<IKeyFactory>();
            kf.RegisterExistingKeys(keys1);
            kf.RegisterExistingKeys(keys2);
            IKeyWithValue<int> kwv = (IKeyWithValue<int>)kf.NewKey();
            Assert.AreEqual(7, kwv.Value);
        }
    }
}
