﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VersionLib;

namespace VersionLibTest
{
    [TestClass]
    public class HierarchicalKeyTest
    {
        [TestMethod, ExpectedException(typeof(ArgumentException))]
        public void CreateNullStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey(null);
            Assert.Fail();
        }

        [TestMethod, ExpectedException(typeof(ArgumentException))]
        public void CreateEmptyStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey(string.Empty);
            Assert.Fail();
        }

        [TestMethod, ExpectedException(typeof(ArgumentException))]
        public void CreateLeadingPeriodStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey(".1");
            Assert.Fail();
        }

        [TestMethod, ExpectedException(typeof(ArgumentException))]
        public void CreateTrailingPeriodStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("1.");
            Assert.Fail();
        }

        [TestMethod, ExpectedException(typeof(ArgumentException))]
        public void CreateUnseparatedPeriodStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("1..1");
            Assert.Fail();
        }

        [TestMethod]
        public void CreateDigitStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("12345");
            Assert.AreEqual("12345", hk.ToString());
        }

        [TestMethod]
        public void CreateMultipleDigitStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("12.345.5.4321");
            Assert.AreEqual("12.345.5.4321", hk.ToString());
        }

        [TestMethod]
        public void CreateNonDigitStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("Fred1");
            Assert.AreEqual("Fred1", hk.ToString());
        }

        [TestMethod]
        public void CreateMultipleNonDigitStringTest()
        {
            HierarchicalKey hk = new HierarchicalKey("Fred.Bloggs.1");
            Assert.AreEqual("Fred.Bloggs.1", hk.ToString());
        }

        [TestMethod]
        public void CreateIntTest()
        {
            HierarchicalKey hk = new HierarchicalKey(312546);
            Assert.AreEqual("312546", hk.ToString());
        }

        [TestMethod]
        public void IntegerValueTest()
        {
            HierarchicalKey hk = new HierarchicalKey("1.2.3.4");
            Assert.AreEqual("0001.0002.0003.0004", hk.Value);
        }

        [TestMethod]
        public void MixedValueTest()
        {
            HierarchicalKey hk = new HierarchicalKey("Fred.4.Bill");
            Assert.AreEqual("Fred.0004.Bill", hk.Value);
        }

        [TestMethod]
        public void CompareTest()
        {
            HierarchicalKey hk1 = new HierarchicalKey("Fred.4.Bill");
            HierarchicalKey hk2 = new HierarchicalKey("Fred.5.Bill");
            Assert.AreEqual(-1, hk1.CompareTo(hk2));
        }

        [TestMethod]
        public void EqualityTest()
        {
            HierarchicalKey hk1 = new HierarchicalKey("Fred.04.Bill");
            HierarchicalKey hk2 = new HierarchicalKey("Fred.0004.Bill");
            Assert.AreEqual(0, hk1.CompareTo(hk2));
        }
    }
}
