﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VersionLib
{
    /// <summary>
    /// Generator for new instances of versions of an object
    /// </summary>
    /// <typeparam name="T">The type of object being versioned</typeparam>
    
    public interface IVersionOfFactory<T>
    {
        /// <summary>
        /// Create an instance of a T at time 'starts'
        /// </summary>
        /// <param name="starts">The earliest time from which these values apply</param>
        /// <param name="val">The object to occupy that time slice</param>
        /// <param name="copyObject">True to deep copy the object</param>
        /// <returns>The created, time-stamped object</returns>
        
        IVersionOf<T> Create(DateTime starts, T val, bool copyObject);

        /// <summary>
        /// Used so that BinarySearch can search a list of tracked objects.
        /// Note that the Value property is never initialised, as it is
        /// never used. We are only interested in the time for a BinarySearch.
        /// </summary>
        /// <param name="starts">Time to search for</param>

        IVersionOf<T> Create(DateTime starts);
    }

    public class VersionOfFactory<T> : IVersionOfFactory<T>
    {
        /// <summary>
        /// Create an instance of a T at time 'starts'
        /// </summary>
        /// <param name="starts">The earliest time from which these values apply</param>
        /// <param name="val">The object to occupy that time slice</param>
        /// <param name="copyObject">True to deep copy the object</param>
        /// <returns>The created, time-stamped object</returns>

        public IVersionOf<T> Create(DateTime starts, T val, bool copyObject)
        {
            return new VersionOf<T>(starts, val, copyObject);
        }

        /// <summary>
        /// Used so that BinarySearch can search a list of tracked objects.
        /// Note that the Value property is never initialised, as it is
        /// never used. We are only interested in the time for a BinarySearch.
        /// </summary>
        /// <param name="starts">Time to search for</param>

        public IVersionOf<T> Create(DateTime starts)
        {
            return new VersionOf<T>(starts);
        }
    }
}
