﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SimpleInjector;
using SimpleInjector.Extensions;
using SimpleInjector.Packaging;
using System.Reflection;

namespace VersionLib
{
    public class VersionLibPackage : IPackage
    {
        /// <summary>
        /// The shared reference to the library container
        /// </summary>
        public static Container Container
        {
            get;
            private set;
        }

        /// <summary>
        /// Called by discovery of types implementing the
        /// SimpleInjector.Packaging.IPackage interface to
        /// register types and interfaces for this version library.
        /// </summary>
        /// <param name="container">The SimpleInjector 
        /// top-level container</param>
        
        public void RegisterServices(Container container)
        {
            Container = container;
            container.RegisterSingleton<IKeyFactory>(new KeyFactory());
            container.Register(typeof(IVersioned<>), typeof(Versioned<>));
            container.Register(typeof(IVersionOfFactory<>), typeof(VersionOfFactory<>));
            container.Register(typeof(IVersionedFactory<>), typeof(VersionedFactory<>));
        }
    }
}
