﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VersionLib
{
    /// <summary>
    /// Some utility functions that encode/decode
    /// unsigned long integers into character strings
    /// using 6 bits per character.
    /// </summary>
    
    public static class KeyStringUtil
    {
        private static string keyChars =
            "0123456789ABCDEF" +
            "GHIJKLMNOPQRSTUV" +
            "WXYZabcdefghijkl" +
            "mnopqrstuvwxyz@_";

        /// <summary>
        /// Convert a long integer representation
        /// of a key into a base 64 string
        /// </summary>
        /// <param name="l">The value to be converted</param>
        /// <returns>The string representation of the key. Note
        /// that a zero valued key returns an empty string.</returns>

        public static string EncodeKeyStringBase64(ulong l)
        {
            if (l == 0)
                return string.Empty;
            else
                return EncodeKeyStringBase64(l >> 6) + keyChars[(int)(l & 0x3F)];
        }

        /// <summary>
        /// Convert a string representation of a
        /// key into the equivalent long integer
        /// </summary>
        /// <param name="ks">The key string to be converted</param>
        /// <returns>The long integer representation of the key</returns>

        public static ulong DecodeKeyStringBase64(string ks)
        {
            ulong result = 0;
            foreach (char c in ks)
            {
                result <<= 6;
                if (c >= '0' && c <= '9')
                    result |= (uint)(c - '0');
                else if (c >= 'A' && c <= 'Z')
                    result |= (uint)(10 + c - 'A');
                else if (c >= 'a' && c <= 'z')
                    result |= (uint)(36 + c - 'a');
                else if (c == '@')
                    result |= 62u;
                else if (c == '_')
                    result |= 63u;
            }
            return result;
        }
    }
}
