﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace VersionLib
{
    /// <summary>
    /// Extension methods used for cloning objects
    /// </summary>
    
    public static class DeepCloneExtensions
    {
        /// <summary>
        /// Deep copy an object
        /// </summary>
        /// <typeparam name="T">The type of object to be copied</typeparam>
        /// <param name="RealObject">The object instance to be deep-cloned</param>
        /// <returns>The deep copy of the object</returns>
        /// <exception cref="ArgumentException">Throws an ArgumentException
        /// when the object being cloned is not serializable</exception>
        
        public static T DeepClone<T>(this T RealObject)
        {
            if (typeof(T).IsSerializable)
            {
                using (Stream objectStream = new MemoryStream())
                {
                    IFormatter formatter = new BinaryFormatter();
                    formatter.Serialize(objectStream, RealObject);
                    objectStream.Seek(0, SeekOrigin.Begin);
                    return (T)formatter.Deserialize(objectStream);
                }
            }
            else
                throw new ArgumentException("Type " + typeof(T).Name + " not serializable");
        }
    }
}
