﻿// AngularJS controller for ViewItems page

function ViewItemController($scope, $http) {
    $scope.serverUrl = getWebApiPath();
    $scope.siteVersion = getSiteVersion();
    $scope.tfsProjects = [
        { value: 0, text: "DataWarehouse" },
        { value: 1, text: "FTP" }
    ];
    $scope.tfsProject = $scope.tfsProjects[0];

    $scope.newPage = function (rel) {
        $scope.setPage($scope.pageNumber + rel);
    };

    $scope.setPage = function (pgNum) {
        $scope.pageNumber = pgNum;
        if ($scope.pageNumber < 0)
            $scope.pageNumber = 0;
        var maxPage = Math.floor($scope.violations.length / $scope.pageSize);
        if ($scope.pageNumber > maxPage)
            $scope.pageNumber = maxPage;
        $scope.pageViolations = $scope.violations
            .slice($scope.pageNumber * $scope.pageSize,
            (1 + $scope.pageNumber) * $scope.pageSize);
    };

    $scope.getViolSuccess = function (response) {
        $scope.violations = response.data;
        for (var i = 0; i < $scope.violations.length; i++) {
            var wi = $scope.violations[i];
            wi.Source.wit = wi.Source.WorkItemType.slice(0, 3);
        }
        $scope.pageSize = 16;
        $scope.setPage(0);
        $scope.retrieving = false;
    };

    $scope.getViolFail = function (response) {
        $scope.retrieving = false;
        alert("Retrieving TFS violations failed: Response " + response.status
            + ", " + response.statusText);
    };

    $scope.GetViolations = function (days, area, iter, who) {
        $scope.retrieving = true;
        var filterData = { Project: $scope.tfsProject.text, Days: days, Area: area, Iteration: iter, Editor: who };
        var serviceURL = $scope.serverUrl + "Violation";
        $scope.workItems = $http
            .post(serviceURL, filterData)
            .then($scope.getViolSuccess, $scope.getViolFail);
    };

    $scope.GetFilters = function () {
        $scope.durations = [
            { value: 0, text: "TFS installed" },
            { value: 1, text: "1 day ago" },
            { value: 7, text: "1 week ago" },
            { value: 28, text: "4 weeks ago" }
        ];
        $scope.durationSelected = $scope.durations[0];

        var serviceURL = $scope.serverUrl + "Filters/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                    $scope.editors = response.data.Editors;
                    $scope.editors.push("-");
                    $scope.editorSelected = $scope.editors[$scope.editors.length - 1];
                    $scope.areas = response.data.Areas;
                    $scope.areas.push("-");
                    $scope.areaSelected = $scope.areas[$scope.areas.length - 1];
                    $scope.iterations = response.data.Iterations;
                    $scope.iterations.push("-");
                    $scope.iterationSelected = $scope.iterations[$scope.iterations.length - 1];
                },
                function errorCallback(response) {
                    alert("GetFilters failed: Response " + response.status
                        + ", " + response.statusText);
                });
    };

    $scope.filterChanged = function () {
        $scope.GetViolations(
            $scope.durationSelected.value,
            $scope.areaSelected,
            $scope.iterationSelected,
            $scope.editorSelected);
    };

    $scope.resetTFS = function () {
        var serviceURL = $scope.serverUrl + "Reset/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                },
                function errorCallback(response) {
                    alert("Reset TFS failed: Response " + response.status
                        + ", " + response.statusText);
                });
    };

    $scope.projectChanged = function () {
        $scope.violations = [];
        $scope.retrieving = true;
        $scope.resetTFS();
        $scope.GetFilters();
        $scope.filterChanged();
    }

    $scope.violations = [];
    $scope.retrieving = true;
    $scope.resetTFS();
    $scope.GetFilters();
    if (window.location.search.length > 0) {
        var qsArgs = parseQueryString(window.location.search.substring(1));
        if ("team" in qsArgs && qsArgs.team && qsArgs.team.length > 0)
            $scope.areaSelected = "DataWarehouse\\Stream " + qsArgs.team;
        if ("sprint" in qsArgs && qsArgs.sprint && qsArgs.sprint.length > 0)
            $scope.iterationSelected = "DataWarehouse\\Sprint " + qsArgs.sprint;
        $scope.filterChanged();
    }
    else
        $scope.GetViolations(0, "-", "-", "-");
}

angular
    .module('ViewItemApp', [])
    .controller('ViewItemController', ViewItemController);
