﻿// AngularJS controller for TFS usage page

function VelocityController($scope, $http) {
    $scope.serverUrl = getWebApiPath();
    $scope.siteVersion = getSiteVersion();
    $scope.tfsProjects = [
        { value: 0, text: "DataWarehouse" },
        { value: 1, text: "FTP" }
    ];
    $scope.tfsProject = $scope.tfsProjects[0];

    $scope.GetFilters = function () {
        $scope.retrieving++;
        var serviceURL = $scope.serverUrl + "Filters/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                    $scope.areas = response.data.Areas;
                    $scope.areas.unshift("All");
                    $scope.areaSelected = $scope.areas[0];
                    $scope.iterations = response.data.Iterations;
                    $scope.iterations.unshift("All");
                    $scope.iterationSelected = $scope.iterations[0];
                    $scope.retrieving--;
                },
                function errorCallback(response) {
                    $scope.retrieving--;
                    alert("Getting teams and sprints failed: Response " + response.status
                        + ", " + response.statusText);
                });
    };

    $scope.SanitizeIteration = function () {
        var proj = $scope.tfsProject.text;
        if (typeof $scope.iterationSelected !== "undefined" &&
            $scope.iterationSelected.length > proj.length &&
            $scope.iterationSelected.slice(0, proj.length + 1) == proj + "\\") {
            return $scope.iterationSelected.slice(proj.length + 1);
        }
        else
            return null;
    };

    $scope.SanitizeArea = function () {
        var proj = $scope.tfsProject.text;
        if (typeof $scope.areaSelected !== "undefined" &&
            $scope.areaSelected.length > proj.length &&
            $scope.areaSelected.slice(0, proj.length + 1) == proj + "\\") {
            return $scope.areaSelected.slice(proj.length + 1);
        }
        else
            return null;
    };

    $scope.GetVEStats = function () {
        $scope.retrieving++;
        var sanitizedIter = $scope.SanitizeIteration();
        var sanitizedArea = $scope.SanitizeArea();
        var filterData = { Area: "", Iteration: "" };
        if (sanitizedIter)
            filterData.Iteration = sanitizedIter;
        if (sanitizedArea)
            filterData.Area = sanitizedArea;
        var serviceURL = $scope.serverUrl + "Stats";
        $scope.workItems = $http
            .post(serviceURL, filterData)
            .then(
                function successCallback(response) {
                    $scope.velocityStats = response.data;
                    $scope.retrieving--;
                },
                function errorCallback(response) {
                    $scope.retrieving--;
                    alert("Getting team stats failed: Response " + response.status
                        + ", " + response.statusText);
                });
    }

    $scope.filterChanged = function () {
        $scope.GetVEStats();
    };

    $scope.reset = function () {
        var serviceURL = $scope.serverUrl + "Reset/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                },
                function errorCallback(response) {
                    alert("Failed to reset server TFS cache: Response " + response.status
                        + ", " + response.statusText);
                });
    }

    $scope.retrieving = 0;
    $scope.sprintItems = [];
    $scope.reset();
    $scope.GetFilters();
    $scope.filterChanged();
}

angular
    .module('VelocityApp', [])
    .controller('VelocityController', VelocityController);
