﻿// AngularJS controller for TFS usage page

function TfsUsageController($scope, $http) {
    $scope.serverUrl = getWebApiPath();
    $scope.siteVersion = getSiteVersion();
    $scope.tfsProjects = [
        { value: 0, text: "DataWarehouse" },
        { value: 1, text: "FTP" }
    ];
    $scope.tfsProject = $scope.tfsProjects[0];

    $scope.GetFilters = function () {
        $scope.retrieving = true;
        var serviceURL = $scope.serverUrl + "Filters/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                    $scope.areas = response.data.Areas;
                    $scope.areaSelected = $scope.areas[6];
                    $scope.iterations = response.data.Iterations;
                    $scope.iterationSelected = $scope.iterations[8];
                    $scope.retrieving = false;
                },
                function errorCallback(response) {
                    $scope.retrieving = false;
                    alert("Getting teams and sprints failed: Response " + response.status
                        + ", " + response.statusText);
                });
    };

    $scope.SanitizeIteration = function () {
        var proj = $scope.tfsProject.text;
        if (typeof $scope.iterationSelected !== "undefined" &&
            $scope.iterationSelected.length > proj.length &&
            $scope.iterationSelected.slice(0, proj.length + 1)
            == proj + "\\") {
            var x = $scope.iterationSelected.slice(proj.length + 1);
            //var find = new RegExp(' ', 'g');
            //return x.replace(find, '%20');
            return x;
        }
        else
            return null;
    }

    $scope.GetTeamStats = function () {
        $scope.retrieving = true;
        var sanitizedIter = $scope.SanitizeIteration();
        if (sanitizedIter)
        {
            var filterData = { Area: "", Iteration: sanitizedIter };
            var serviceURL = $scope.serverUrl + "TfsUsage";
            $scope.workItems = $http
                .post(serviceURL, filterData)
                .then(
                    function successCallback(response) {
                        $scope.teamStats = response.data;
                        $scope.retrieving = false;
                    },
                    function errorCallback(response) {
                        $scope.retrieving = false;
                        alert("Getting team stats failed: Response " + response.status
                            + ", " + response.statusText);
                    });
        }
    }

    $scope.filterChanged = function () {
        $scope.GetTeamStats();
    };

    $scope.reset = function () {
        var serviceURL = $scope.serverUrl + "Reset/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                },
                function errorCallback(response) {
                    alert("Failed to reset server TFS cache: Response " + response.status
                        + ", " + response.statusText);
                });
    }

    $scope.sprintItems = [];
    $scope.reset();
    $scope.GetFilters();
    $scope.filterChanged();
}

angular
    .module('TfsUsageApp', [])
    .controller('TfsUsageController', TfsUsageController);
