﻿// AngularJS controller for EndSprint page

function EndSprintController($scope, $http) {
    $scope.serverUrl = getWebApiPath();
    $scope.siteVersion = getSiteVersion();
    $scope.tfsProjects = [
        { value: 0, text: "DataWarehouse" },
        { value: 1, text: "FTP" }
    ];
    $scope.tfsProject = $scope.tfsProjects[0];

    $scope.getSprintItemSuccess = function (response) {
        $scope.sprintItems = response.data;
        for (var i = 0; i < $scope.sprintItems.length; i++) {
            var wi = $scope.sprintItems[i];
            wi.Source.wit = wi.Source.WorkItemType.slice(0, 3);
        }
        $scope.retrieving = false;
    };

    $scope.getSprintItemFail = function (response) {
        $scope.retrieving = false;
        alert("Retrieving sprint items failed: Response " + response.status
            + ", " + response.statusText);
    };

    $scope.GetSprintItems = function (area, iter) {
        $scope.retrieving = true;
        var filterData = { Area: area, Iteration: iter };
        var serviceURL = $scope.serverUrl + "SprintItems";
        $scope.workItems = $http
            .post(serviceURL, filterData)
            .then($scope.getSprintItemSuccess, $scope.getSprintItemFail);
    };

    $scope.GetFilters = function () {
        $scope.retrieving = true;
        var serviceURL = $scope.serverUrl + "Filters/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                    $scope.areas = response.data.Areas;
                    $scope.areaSelected = $scope.areas[6];
                    $scope.iterations = response.data.Iterations;
                    $scope.iterationSelected = $scope.iterations[8];
                    $scope.retrieving = false;
                },
                function errorCallback(response) {
                    $scope.retrieving = false;
                    alert("Getting teams and sprints failed: Response " + response.status
                        + ", " + response.statusText);
                });
    };

    $scope.filterChanged = function () {
        $scope.GetSprintItems(
            $scope.areaSelected,
            $scope.iterationSelected);
    };

    $scope.reset = function () {
        var serviceURL = $scope.serverUrl + "Reset/" + $scope.tfsProject.text;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                },
                function errorCallback(response) {
                    alert("Failed to reset server TFS cache: Response " + response.status
                        + ", " + response.statusText);
                });
    }

    $scope.LinkAction = function (id, idx) {
        var serviceURL = $scope.serverUrl + "Rollover/" + $scope.tfsProject.text + "/" + id + "/" + idx;
        $scope.retrieving = true;
        $scope.workItems = $http
            .get(serviceURL)
            .then(
                function successCallback(response) {
                    var ret = response.data.toString();
                    if (ret.length != 0)
                        alert("Failed to roll over PBI/Bug: " + ret);
                    else
                        $scope.filterChanged();
                    $scope.retrieving = false;
                },
                function errorCallback(response) {
                    alert("Failed to roll over PBI/Bug: Response " + response.status
                        + ", " + response.statusText);
                    $scope.retrieving = false;
                });
        return false;
    };

    $scope.sprintItems = [];
    $scope.reset();
    $scope.GetFilters();
    //var qsArgs = parseQueryString(window.location.search.substring(1));
    //if ("team" in qsArgs && qsArgs.team && qsArgs.team.length > 0)
    //    $scope.areaSelected = "DataWarehouse\\Stream " + qsArgs.team;
    //if ("sprint" in qsArgs && qsArgs.sprint && qsArgs.sprint.length > 0)
    //    $scope.iterationSelected = "DataWarehouse\\Sprint " + qsArgs.sprint;
    $scope.filterChanged();
}

angular
    .module('EndSprintApp', [])
    .controller('EndSprintController', EndSprintController);
