﻿/*
 * Author: 
 *  S D Smith
 *  
 * Date:
 *  Oct 2015
 *  
 * Purpose: 
 *  Entry point for console application that applies business rule checks to TFS.
 *  Used as part of the TFS sanity checks to make sure TFS users in Analytics
 *  conform to recommended best practices in using the work items to
 *  plan and track backlogs and sprints.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TFSLib;
using System.IO;
using Owin;
using System.Web.Http;
using Microsoft.Owin.Hosting;
using Microsoft.Owin.Cors;

namespace TFSLibPerformance
{
    class Program
    {
        static void Main(string[] args)
        {
            // Command line behaviours:
            // TFSLibPerformance.exe filePath.txt
            //  - Generates an output summary text file at the specified path
            // TFSLibPerformance.exe
            //  - Launches the application as a console host for the OWIN web 
            //    services to support a single page application

            if (args.Length == 0)
            {
                RunOwinHostedApp();
                return;
            }

            if (File.Exists(args[0]))
                File.Delete(args[0]);
            using (StreamWriter sw = new StreamWriter(args[0]))
            {
                var violations = RulesEngine.Run("DataWarehouse");
                foreach (var violation in violations)
                    sw.WriteLine(violation.ToString());
            }
        }

        private static void RunOwinHostedApp()
        {
            string baseUri = "http://localhost:8080";

            Console.WriteLine("Loading TFS work item snapshot. Please wait (approx. 15 seconds) ...");
            WebApp.Start<Startup>(baseUri);
            if (Models.ItemModel.ItemAdapter != null)
            {
                Console.WriteLine("... Snapshot loaded. Press Enter to exit.", baseUri);
                System.Diagnostics.Process.Start("Pages\\ViewItems.html");
            }
            else
                Console.WriteLine("... Unable to connect to TFS server. Press Enter to exit");
            Console.ReadLine();
        }
    }

    public class Startup
    {
        // Required by the Katana pipeline

        public void Configuration(IAppBuilder app)
        {
            var webApiConfiguration = ConfigureWebApi();

            // Pass the routing configuration into theWebApi.Owin library

            app.UseCors(CorsOptions.AllowAll);
            app.UseWebApi(webApiConfiguration);
        }

        private HttpConfiguration ConfigureWebApi()
        {
            var config = new HttpConfiguration();
            config.MapHttpAttributeRoutes();
            //config.Routes.MapHttpRoute
            //(
            //    "DefaultApi",
            //    "api/{controller}/{id}",
            //    new {  id = RouteParameter.Optional }
            //);
            config.Formatters.JsonFormatter.SupportedMediaTypes.Add
                (new System.Net.Http.Headers.MediaTypeHeaderValue("text/html"));
            return config;
        }
    }
}
