﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TFSLib;

namespace TFSLibPerformance.Models
{
    public static class ItemModel
    {
        private static string tfsTeamProjectName = "DataWarehouse";
        private static WorkItemAdapter tfsAdapter;
        private static List<ViolationSet> violations;

        /// <summary>
        /// Retrieve the list of all rule violations
        /// </summary>
        
        public static List<ViolationSet> Violations
        {
            get
            {
                if (violations == null)
                    violations = RulesEngine.Run(ItemAdapter);
                return violations;
            }
        }

        /// <summary>
        /// Retrive the work item adapter that gives access
        /// to all work items and item links in TFS
        /// </summary>
        
        public static WorkItemAdapter ItemAdapter
        {
            get
            {
                if (tfsAdapter == null)
                    tfsAdapter = WorkItemAdapter.ItemAdapter(tfsTeamProjectName);
                return tfsAdapter;
            }
        }
    }
}
