﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;
using System.Net.Http;
using TFSLib;
using TFSLibPerformance.Models;

namespace TFSLibPerformance.Controllers
{
    public class ViolationController : ApiController
    {
        /// <summary>
        /// Look up the set of all Items from the work item store.
        /// Should not be used as it returns a large number of items.
        /// </summary>
        /// <returns>The set of all items from the work item store</returns>

        [Route("api/Violation")]
        public IEnumerable<ViolationSet> Get()
        {
            return ItemModel.Violations;
        }

        /// <summary>
        /// Find an item by its specific primary key value. For the
        /// work item store in TFS this means the System.Id value for
        /// a work item.
        /// </summary>
        /// <param name="id">The unique integer ID of the work item, as previously
        /// allocated by TFS</param>
        /// <returns>The found item, or an exception thrown if not found</returns>

        [Route("api/Violation/{first:int}/{size:int}")]
        public IEnumerable<ViolationSet> Get(int first, int size)
        {
            return ItemModel.Violations.Skip(first).Take(size);
        }
    }
}
