﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;
using System.Net.Http;
using TFSLib;
using TFSLibPerformance.Models;

namespace TFSLibPerformance.Controllers
{
    public class ItemController : ApiController
    {
        /// <summary>
        /// Look up the set of all Items from the work item store.
        /// Should not be used as it returns a large number of items.
        /// </summary>
        /// <returns>The set of all items from the work item store</returns>

        [Route("api/Item")]
        public IEnumerable<Item> Get()
        {
            return ItemModel.ItemAdapter.AllCurrentWorkItems.Take(16);
        }

        /// <summary>
        /// Find an item by its specific primary key value. For the
        /// work item store in TFS this means the System.Id value for
        /// a work item.
        /// </summary>
        /// <param name="id">The unique integer ID of the work item, as previously
        /// allocated by TFS</param>
        /// <returns>The found item, or an exception thrown if not found</returns>

        [Route("api/Item/{id:int}")]
        public Item Get(int id)
        {
            Item foundItem = ItemModel.ItemAdapter.ItemFromId(id);
            if (foundItem == null)
                throw new HttpResponseException(System.Net.HttpStatusCode.NotFound);
            else
                return foundItem;
        }

        /// <summary>
        /// Insert a new Item into the work item store
        /// </summary>
        /// <param name="item">The new item to be installed</param>
        /// <returns>Success code</returns>

        [Route("api/Item")]
        [HttpPost]
        public IHttpActionResult Post([FromBody] Item item)
        {
            if (item == null)
                return BadRequest("Posted item is null");

            Item foundItem = ItemModel.ItemAdapter.ItemFromId(item.Id);
            if (foundItem != null)
                return BadRequest("Item with this ID already exists");

            // Code to insert a new item should be put here

            return Ok();
        }

        /// <summary>
        /// Overwrite an existing Item in the work item store
        /// </summary>
        /// <param name="item">The modified item to be updated</param>
        /// <returns>Success code</returns>

        [Route("api/Item")]
        [HttpPut]
        public IHttpActionResult Put([FromBody] Item item)
        {
            if (item == null)
                return BadRequest("Put item is null");

            Item foundItem = ItemModel.ItemAdapter.ItemFromId(item.Id);
            if (foundItem == null)
                return NotFound();

            // Code to overwrite an existing item should be put here

            return Ok();
        }

        /// <summary>
        /// Delete the Item with the specified ID
        /// </summary>
        /// <param name="id">ID of item to be deleted</param>
        /// <returns>Success code</returns>
        
        [Route("api/item/{id:int}")]
        [HttpDelete]
        public IHttpActionResult Delete(int id)
        {
            Item foundItem = ItemModel.ItemAdapter.ItemFromId(id);
            if (foundItem == null)
                return NotFound();

            // Take action to remove the specified item here

            return Ok();
        }
    }
}
