﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    /// <summary>
    /// A cluster of violations all pertaining to the same source item
    /// </summary>
    
    public class ViolationSet
    {
        /// <summary>
        /// The work item for which these violations are extant
        /// </summary>
        
        public Item Source
        {
            get;
            private set;
        }

        /// <summary>
        /// The list of violations associated with this source item
        /// </summary>
        
        public List<RuleViolation> Violations
        {
            get;
            private set;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="src">The source work item</param>
        /// <param name="violations">The list of violations</param>
        
        public ViolationSet(Item src, List<RuleViolation> violations)
        {
            Source = src;
            Violations = violations;
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            RuleViolation.RenderWorkItem(sb, Source, 0);
            foreach (RuleViolation v in Violations)
                v.RenderViolation(sb);
             return sb.ToString();
        }
    }
}
