﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    public class TFSUsage
    {
        public string User
        {
            get;
            set;
        }

        public string Team
        {
            get;
            set;
        }

        public int Updates
        {
            get;
            set;
        }

        public string AverageFrequency
        {
            get;
            set;
        }

        public string MaxInterval
        {
            get;
            set;
        }

        public DateTime LastUpdate
        {
            get;
            set;
        }
    }

    public class TFSUsageGroup
    {
        public string Team
        {
            get;
            set;
        }

        public List<TFSUsage> Members
        {
            get;
            set;
        }

        public TFSUsageGroup(string team)
        {
            Team = team;
            Members = new List<TFSUsage>();
        }
    }

    public class TeamSprintStats
    {
        public string Team
        {
            get;
            set;
        }

        public string Sprint
        {
            get;
            set;
        }

        public double StartingPoints
        {
            get;
            set;
        }

        public double TotalInitialHours
        {
            get;
            set;
        }

        public double TotalHoursBurned
        {
            get;
            set;
        }

        public double HoursBurnedPerPoint
        {
            get
            {
                if (StartingPoints > 0)
                    return TotalHoursBurned / StartingPoints;
                else
                    return 0.0;
            }
        }

        public double ActualPointsPerSprint
        {
            get
            {
                return StartingPoints * TotalHoursBurned / TotalInitialHours;
            }
        }
    }
}
