﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    public class ScheduleInfo
    {
        public string IterationPath
        {
            get;
            set;
        }

        public DateTime? StartDate
        {
            get;
            set;
        }

        public DateTime? EndDate
        {
            get;
            set;
        }

        /// <summary>
        /// Given a time on a day of the week, return
        /// the time a multiple of 24 hours later that
        /// is on the next week day
        /// </summary>
        /// <param name="t">Earlier time</param>
        /// <returns>Same time on next week day</returns>

        public static DateTime NextWeekDay(DateTime t)
        {
            if (t.DayOfWeek == DayOfWeek.Friday)
                return t.AddDays(3.0);
            if (t.DayOfWeek == DayOfWeek.Saturday)
                return t.AddDays(2.0);
            return t.AddDays(1.0);
        }

        /// <summary>
        /// Enumerate the weekdays in the sprint
        /// </summary>
        
        public IEnumerable<DateTime> DayEnds
        {
            get
            {
                if (StartDate != null)
                    for (DateTime t = StartDate.Value.Date.AddDays(1.0).AddSeconds(-1.0);
                        t < StartDate.Value.AddDays(28.0) &&
                        (!EndDate.HasValue || t < EndDate.Value.AddDays(1.0).Date);
                        t = NextWeekDay(t))
                        yield return t;
            }
        }
    }
}
