﻿/*
 * Author: 
 *  S D Smith
 *  
 * Date:
 *  Oct 2015
 *  
 * Purpose: 
 *  Attributes applied to rule checking functions applied to TFS.
 *  Used as part of the TFS sanity checks to make sure TFS users in Analytics
 *  conform to recommended best practices in using the work items to
 *  plan and track backlogs and sprints.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    /// <summary>
    /// Attribute applied to a class containing TFS
    /// validation rules
    /// </summary>
    
    [AttributeUsage(AttributeTargets.Class)]
    public class RuleClassAttribute : System.Attribute
    {

    }

    /// <summary>
    /// Attribute applied to a method in a RuleClass
    /// that returns an IEnumerable&lt;WorkItemViolation&gt;
    /// and that applies a rule to a single work item
    /// </summary>

    [AttributeUsage(AttributeTargets.Method)]
    public class RuleAttribute : System.Attribute
    {

    }

    /// <summary>
    /// Attribute applied to a method in a RuleClass
    /// that returns an IEnumerable&lt;WorkItemViolation&gt;
    /// and that applies rules to a link between two work items
    /// </summary>

    [AttributeUsage(AttributeTargets.Method)]
    public class LinkRuleAttribute : System.Attribute
    {

    }
}
