﻿/*
 * Author: 
 *  S D Smith
 *  
 * Date:
 *  Oct 2015
 *  
 * Purpose: 
 *  Entity class representing a single link between two work items in TFS.
 *  Used as part of the TFS sanity checks to make sure TFS users in Analytics
 *  conform to recommended best practices in using the work items to
 *  plan and track backlogs and sprints.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    /// <summary>
    /// Representation of links between two work items
    /// </summary>
    
    public class ItemLink
    {
        private static int nextId;

        public int Id
        {
            get;
            private set;
        }

        public Item Source
        {
            get;
            private set;
        }

        public Item Target
        {
            get;
            private set;
        }

        public string LinkType
        {
            get;
            private set;
        }

        public ItemLink(Item src, Item tgt, string lt)
        {
            Id = ++nextId;
            LinkType = lt;
            Source = src;
            Target = tgt;
        }
    }
}
