﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    /// <summary>
    /// Non-TFS library implementation of a work item
    /// so that no fields are lazily fetched from TFS
    /// </summary>
    
    public class Item
    {
        public bool Dirty
        {
            get;
            set;
        }

        private int id;
        public int Id
        {
            get { return id; }
            set { Dirty = id != value;  id = value; }
        }

        private string workItemType;
        public string WorkItemType
        {
            get { return workItemType; }
            set { Dirty = workItemType != value; workItemType = value; }
        }

        private string state;
        public string State
        {
            get { return state; }
            set { Dirty = state != value; state = value; }
        }

        private string title;
        public string Title
        {
            get { return title; }
            set { Dirty = title != value; title = value; }
        }

        private string description;
        public string Description
        {
            get { return description; }
            set { Dirty = description != value; description = value; }
        }

        private string iterationPath;
        public string IterationPath
        {
            get { return iterationPath; }
            set { Dirty = iterationPath != value; iterationPath = value; }
        }

        private string areaPath;
        public string AreaPath
        {
            get { return areaPath; }
            set { Dirty = areaPath != value; areaPath = value; }
        }

        private double effort;
        public double Effort
        {
            get { return effort; }
            set { Dirty = effort != value; effort = value; }
        }

        private double remainingWork;
        public double RemainingWork
        {
            get { return remainingWork; }
            set { Dirty = remainingWork != value; remainingWork = value; }
        }

        private string assignedTo;
        public string AssignedTo
        {
            get { return assignedTo; }
            set { Dirty = assignedTo != value; assignedTo = value; }
        }

        private string acceptanceCriteria;
        public string AcceptanceCriteria
        {
            get { return acceptanceCriteria; }
            set { Dirty = acceptanceCriteria != value; acceptanceCriteria = value; }
        }

        private DateTime changedDate;
        public DateTime ChangedDate
        {
            get { return changedDate; }
            set { Dirty = changedDate != value; changedDate = value; }
        }

        private string changedBy;
        public string ChangedBy
        {
            get { return changedBy; }
            set { Dirty = changedBy != value; changedBy = value; }
        }

        public List<Item> History
        {
            get;
            set;
        }

        /// <summary>
        /// Get the state of the item as
        /// it was at the specified time
        /// </summary>
        /// <param name="t">The time from which
        /// we want the item's value</param>
        /// <returns>The item as it was at time 't'</returns>
        
        public Item At(DateTime t)
        {
            if (History != null)
                return History.LastOrDefault(i => i.ChangedDate < t);
            else
                return null;
        }
    }
}
