﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TFSLib
{
    public class EndSprintItem
    {
        /// <summary>
        /// The work item for which sprint ending is taking place
        /// </summary>

        public Item Source
        {
            get;
            private set;
        }

        /// <summary>
        /// Any outstanding violations associated with this item
        /// </summary>
        
        public List<RuleViolation> Violations
        {
            get;
            private set;
        }

        /// <summary>
        /// Description of the action to be taken
        /// </summary>
        
        public string Recommendation
        {
            get;
            private set;
        }

        /// <summary>
        /// The labels on the end of sprint action buttons
        /// </summary>
        
        public string[] Actions
        {
            get;
            private set;
        }

        /// <summary>
        /// Hours estimated under this item
        /// </summary>
        
        public double TotalHours
        {
            get;
            private set;
        }

        /// <summary>
        /// Hours left under this item
        /// </summary>
        
        public double HoursLeft
        {
            get;
            private set;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="i">Item being described</param>
        /// <param name="rec">Recommendation</param>
        /// <param name="th">Total hours of this and all children</param>
        /// <param name="hl">Hours left in this and all children</param>
        /// <param name="v">Any outstanding violations associated with this item</param>
        
        public EndSprintItem(Item i, string rec, string[] actions, double th, double hl, IEnumerable<RuleViolation> v)
        {
            Source = i;
            Recommendation = rec;
            Actions = actions;
            TotalHours = th;
            HoursLeft = hl;
            if(v != null)
                Violations = new List<RuleViolation>(v);
            else
                Violations = new List<RuleViolation>(0);
        }
    }
}
