package com.kpl.CourierMgmt.FeatureTests;



import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.util.regex.Pattern;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.*;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class UITests {
	private WebDriver driver;
    private WebDriverWait waiter;
    private String pathToIndexPage = "file:///home/osboxes/Documents/DotNetCourierService/CourierSite/index.html";
    @BeforeEach
    public void Setup() {
    	System.setProperty("webdriver.chrome.driver", "/home/osboxes/Documents/Ex4.1Sol/chromedriver_linux64/chromedriver");
    	driver = new ChromeDriver();
        waiter = new WebDriverWait(driver, 10L);
        driver.get(pathToIndexPage);
    }
    
    @AfterEach
    public void TearDown() {
    	driver.close();
    	driver.quit();
    }
    
    private void TypeInputText(String id, String text)
    {
        WebElement elem = driver.findElement(By.id(id));
        elem.clear();
        elem.sendKeys(text);
    }

    private void ClickButton(String id)
    {
        WebElement button = driver.findElement(By.id(id));
        button.click();
    }

    private void WaitUntilContainsText(String id)
    {
        // A web driver waiter needs to be passed a
        // Func<IWebDriver, bool> or a Func<IWebDriver, someRefType>.
        // If the function returns false or null, the wait keeps waiting.
        // When it returns true or an object (which is returned from the
        // Until function to the caller) the wait is over.

        waiter.until(ExpectedConditions.textMatches(By.id(id), Pattern.compile("[^ ]+")));
    }

	@Test
	public void MakeBookingTest() {
		 // ACT

        TypeInputText("customerName", "Sean");
        TypeInputText("customerEmail", "sdsmith@ropley.com");
        TypeInputText("pickupLocation", "50 Victoria Street London");
        TypeInputText("dropLocation", "Brick Lane London");
        TypeInputText("packageWeight", "2.2");
        ClickButton("book");
        WaitUntilContainsText("distance");

        // ASSERT

        assertEquals("Book a courier", driver.getTitle());
        assertFalse(driver.findElement(By.id("booking1")).isDisplayed());
        assertTrue(driver.findElement(By.id("booking2")).isDisplayed());

        // Swap the commenting on the next two lines if switching
        // the fake directions api to the real google api.

        //assertEquals("5", driver.findElement(By.id("distance")).getText());
        assertEquals("6.788", driver.findElement(By.id("distance")).getText());
        //assertEquals("Rapid Roger", driver.findElement(By.id("courierName")).getText());
	}
	
}
