package com.kpl.CourierMgmt.CourierManager;

public class MockPremiumCalculator implements IPremiumCalculator {
	int returnedValue;
    HazardType expectedHazard;
    int expectedValue;
    double expectedDistance;
    double expectedWeight;
    boolean expectationsHaveBeenMet;
    
    /// <summary>
    /// A simple instrumentation interface
    /// </summary>

    public boolean ExpectationsHaveBeenMet()
    {
        return expectationsHaveBeenMet;
    }

    /// <summary>
    /// Create a mock premium calculator with a hard-wired return value, and
    /// expected values for arguments passed to CalculatePremium
    /// </summary>
    /// <param name="returnedValue">The hard wired return value</param>
    /// <param name="expectedHazard">Expected hazard type</param>
    /// <param name="expectedValue">Expected package value</param>
    /// <param name="expectedDistance">Expected distance to be carried</param>
    /// <param name="expectedWeight">Expected package weight</param>

    public MockPremiumCalculator(int returnedValue, HazardType expectedHazard, int expectedValue, double expectedDistance, double expectedWeight)
    {
        this.returnedValue = returnedValue;
        this.expectedHazard = expectedHazard;
        this.expectedValue = expectedValue;
        this.expectedDistance = expectedDistance;
        this.expectedWeight = expectedWeight;
        expectationsHaveBeenMet = false;
    }

    @Override
    public int CalculatePremium(HazardType hazardType, int packageValue, double distance, double weight)
    {
        expectationsHaveBeenMet =
            hazardType == expectedHazard
            && packageValue == expectedValue
            && distance == expectedDistance
            && weight == expectedWeight;
        return returnedValue;
    }

}
