package com.kpl.CourierMgmt.CourierManager;

public class MockFareCalculator implements IFareCalculator {
    int returnedValue;
    double expectedDistance;
    double expectedWeight;
    int numberOfCalls;
    boolean argumentsHaveCorrectValues = false;

    public MockFareCalculator(int retVal, double dist, double wt)
    {
        returnedValue = retVal;
        expectedDistance = dist;
        expectedWeight = wt;
        numberOfCalls = 0;
    }

    @Override
    public int CalculateFare(double distance, double weight)
    {
        numberOfCalls++;
        argumentsHaveCorrectValues = 
            expectedDistance == distance 
            && expectedWeight == weight;
        return returnedValue;
    }

    public boolean ExpectationsHaveBeenMet()
    {
        return argumentsHaveCorrectValues && numberOfCalls == 1;
    }
}
