package com.kpl.CourierMgmt.GoogleMapClient;

/// <summary>
/// Adapter onto the Google maps API for
/// route planning using the road network
/// </summary>

public interface IGoogleMapApi
{
    /// <summary>
    /// Given approximate strings for the origin and
    /// destination of a journey, go and compute
    /// the route used to navigate between them
    /// </summary>
    /// <param name="origin">A string approximating the origin</param>
    /// <param name="destination">A string representing the
    /// destination for the journey</param>
    /// <returns>A Google route object that gives Google's
    /// version of the origin and destination, the turn by
    /// turn route between origin and destination, and
    /// the total distance in kilometres. Returns null if
    /// no route was found.
    /// </returns>
    /// <exception cref="ArgumentException">Thrown if either of
    /// the arguments is null or an empty string</exception>

    IGoogleRoute GetRoute(String origin, String destination);
}
