package com.kpl.CourierMgmt.CourierManager;
import com.kpl.CourierMgmt.GoogleMapClient.*;

public class SchedulerFactory implements ISchedulerFactory
{
    public Scheduler CreateScheduler(IGoogleMapApi gma, IFareCalculator fc, IPremiumCalculator pc)
    {
        return new Scheduler(gma, fc, pc);
    }

    public Scheduler CreateScheduler(IGoogleMapApi gma)
    {
        return CreateScheduler(gma, new BasicFareCalculator(), new BasicPremiumCalculator());
    }

    /// <summary>
    ///  Construct a scheduler for use in the live application. Includes
    ///  a sample set of three couriers.
    /// </summary>
    /// <returns>An end to end scheduler using true Google maps</returns>

    public Scheduler CreateScheduler()
    { 
        Scheduler sch = CreateScheduler(
            new DirectionsApi("AIzaSyAQiYSiDOkvUbcDuPMAbTVHPd_mhGYKuBM"));
        sch.AddCourier("Rapid Roger", "Westminster Bridge, London");
        sch.AddCourier("Lightning Larry", "Waterloo Station, London");
        sch.AddCourier("Agile Agatha", "Piccadilly Circus, London");
        return sch;
    }

    private static Scheduler theScheduler = null;

    /// <summary>
    /// A singleton implementation for use in 'hasty'
    /// implementations!
    /// </summary>

    public static Scheduler Singleton()
    {
        if (theScheduler == null)
            theScheduler = new SchedulerFactory().CreateScheduler();
        return theScheduler;
    }
}
