package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.GoogleMapClient.*;
import java.time.Duration;
import java.time.Instant;

public class CourierBooking
{

    public static Duration PickupWaitingTime = Duration.ofMinutes(5);
    public static Duration DropOffWaitingTime = Duration.ofMinutes(5);

    private IFareCalculator journeyPricer;
    private IPremiumCalculator premiumCalculator;

    public IGoogleRoute Route;
    public double Weight;
    public String ShippingRef;
    public String GetOrigin() { return Route.GetOrigin(); }
    public String GetDestination() { return Route.GetDestination(); }
    public double GetDistance() { return Route.GetDistance(); }

    public Instant EstimatedPickupTime;
    public Instant GetEstimatedDropOffTime() { return EstimatedPickupTime.plus(PickupWaitingTime).plus(Route.GetDuration()); }

    // Route courier takes to get to pickup location.
    // Determined once a courier has been assigned

    public IGoogleRoute PickupRoute;

    // Used for premium pricing courier service

    public HazardType PackageHazardType;
    public int PackageValue;

    public CourierBooking(double weight, IGoogleRoute route, IFareCalculator fc)
    {
    	init(weight, route, fc, null);
    }
    
    public CourierBooking(double weight, IGoogleRoute route, IFareCalculator fc, IPremiumCalculator pc)
    {
    	init(weight, route, fc, pc);
    }
    
    private void init(double weight, IGoogleRoute route, IFareCalculator fc, IPremiumCalculator pc)
    {
        journeyPricer = fc;
        premiumCalculator = pc;

        Weight = weight;
        Route = route;

        // Used for premium pricing

        PackageValue = 0;
        PackageHazardType = HazardType.NonHazardous;
    }

    /// <summary>
    /// Calculate the fare to be charged for delivering this package
    /// </summary>

    public int GetFare()
    {
        int fare = journeyPricer.CalculateFare(GetDistance(), Weight);
        if (premiumCalculator != null)
            fare += premiumCalculator.CalculatePremium(PackageHazardType, PackageValue, GetDistance(), Weight);
        return fare;
    }
}
