package com.kpl.CourierMgmt.CourierManager;

public class BasicFareCalculator implements IFareCalculator {

	@Override
	public int CalculateFare(double distance, double weight) {
		int fare = 0;

        if(distance < 0)
        	throw new IllegalArgumentException("Distance cannot be negative");
        if(weight < 0)
        	throw new IllegalArgumentException("Weight cannot be negative");
        
        // 1 Euro for each km per kg. 1 Euro == 100 cents

        fare = (int)(Math.ceil(distance) * Math.ceil(weight)) * 100;
        
        // Minimum fare is 15 Euros

        if (fare < 1500)
            fare = 1500;

        return fare;
	}

}
