#Author: your.email@your.domain.com
#Keywords Summary :
#Feature: List of scenarios.
#Scenario: Business rule through list of steps with arguments.
#Given: Some precondition step
#When: Some key actions
#Then: To observe outcomes or validation
#And,But: To enumerate more Given,When,Then steps
#Scenario Outline: List of steps for data-driven as an Examples and <placeholder>
#Examples: Container for s table
#Background: List of steps run before each of the scenarios
#""" (Doc Strings)
#| (Data Tables)
#@ (Tags/Labels):To group Scenarios
#<> (placeholder)
#""
## (Comments)
#Sample Feature Definition Template
Feature: Book a Courier
  As a customer I want to book a courier so that my 
  package can be collected and delivered.

  Scenario: Book a single package delivery
    Given I am using the default courier manager
    And I have a 1.0 kg package to go from "Fleet Street London" to "Ludgate Hill London"
    When I book a courier
    Then the booking is successful
    And the distance the courier will carry is 5.0 km

  Scenario Outline: Book a sequence of single package deliveries
    Given I am using the default courier manager
    And I have a <Weight>.<WeightFrac> kg package to go from "<Origin>" to "<Destination>"
    When I book a courier
    Then the booking is successful
    And the distance the courier will carry is <Distance>.<DistanceFrac> km

    Examples: 
      | Weight | WeightFrac | Origin              | Destination         | Distance | DistanceFrac |
      |      1 |          0 | Fleet Street London | Ludgate Hill London |        5 |            0 |
      |      2 |          0 | Petty France London | Fleet Street London |        5 |            0 |
      |      0 |          5 | Petty France London | Ludgate Hill London |        5 |            0 |

  Scenario: Book a set of concurrent deliveries
    Given I am using the default courier manager
    And I have the following deliveries to schedule
      | Weight | Origin              | Destination         |
      |    1.0 | Fleet Street London | Ludgate Hill London |
      |    2.0 | Petty France London | Fleet Street London |
      |    0.5 | Petty France London | Ludgate Hill London |
    When I make these bookings
    Then the couriers, distances and prices are
      | Courier         | Distance | Price |
      | Rapid Roger     |      5.0 |  1500 |
      | Lightning Larry |      5.0 |  1500 |
      | Agile Agatha    |      5.0 |  1500 |
