package com.kpl.CourierMgmt.CourierManager;
import static org.junit.jupiter.api.Assertions.*;

import java.util.stream.Stream;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PremiumCalculatorTests 
{
	IPremiumCalculator pc;

    @BeforeEach
    public void Setup()
    {
        pc = new BasicPremiumCalculator();
    }
    
    @ParameterizedTest
	@MethodSource("premiumFareProvider")
    public void PremiumDataDrivenTest(int expectedResult, HazardType hazard, int value, double distance, double weight)
    {
        assertEquals(expectedResult, pc.CalculatePremium(hazard, value, distance, weight));
    }
	
	static Stream<Arguments> premiumFareProvider() {
		return Stream.of(
			Arguments.of(300, HazardType.NonHazardous, 10000, 3.0, 5.0), // Valuable
			Arguments.of(2500, HazardType.Biological, 9999, 3.0, 5.0),	 // Bio hazard
			Arguments.of(2500, HazardType.Corrosive, 9999, 3.0, 5.0),	 // Corrosive
			Arguments.of(2500, HazardType.Flammable, 9999, 3.0, 5.0),	 // Flammable
			Arguments.of(2800, HazardType.Corrosive, 10000, 3.0, 5.0)	 // Hazardous and valuable
		);
	}
	
    @Test
    public void NonHazardousLowValue()
    {
        assertEquals(0, pc.CalculatePremium(HazardType.NonHazardous, 9999, 3, 5));
    }
}
