/*
 * Decompiled with CFR 0.152.
 */
package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.CourierManager.BookingDetails;
import com.kpl.CourierMgmt.CourierManager.Courier;
import com.kpl.CourierMgmt.CourierManager.CourierBooking;
import com.kpl.CourierMgmt.CourierManager.IFareCalculator;
import com.kpl.CourierMgmt.CourierManager.IPremiumCalculator;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleMapApi;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleRoute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class Scheduler {
    private IGoogleMapApi mapApi;
    private IFareCalculator fareCalculator;
    private IPremiumCalculator premiumCalculator;
    public List<Courier> Couriers;

    public Scheduler(IGoogleMapApi gma, IFareCalculator fc, IPremiumCalculator pc) {
        this.mapApi = gma;
        this.fareCalculator = fc;
        this.premiumCalculator = pc;
        this.Couriers = new ArrayList<Courier>();
    }

    public Courier AddCourier(String name, String startLocation) {
        this.Couriers.add(new Courier(this.mapApi, name, startLocation));
        return this.Couriers.get(this.Couriers.size() - 1);
    }

    public Courier RemoveCourier(String name) {
        Courier removalCandidate = null;
        for (Courier c : this.Couriers) {
            if (!c.Name.equals(name)) continue;
            removalCandidate = c;
            break;
        }
        if (removalCandidate != null) {
            this.Couriers.remove(removalCandidate);
        }
        return removalCandidate;
    }

    public List<CourierBooking> GetBookings() {
        ArrayList<CourierBooking> bookings = new ArrayList<CourierBooking>();
        for (Courier c : this.Couriers) {
            for (CourierBooking cb : c.Schedule) {
                bookings.add(cb);
            }
        }
        return bookings;
    }

    public List<BookingDetails> GetBookingDetails() {
        ArrayList<BookingDetails> bookings = new ArrayList<BookingDetails>();
        for (Courier c : this.Couriers) {
            for (CourierBooking cb : c.Schedule) {
                bookings.add(new BookingDetails(c, cb));
            }
        }
        return bookings;
    }

    public BookingDetails DetailsFromBooking(CourierBooking cb) {
        for (BookingDetails bd : this.GetBookingDetails()) {
            if (bd.Booking != cb) continue;
            return bd;
        }
        return null;
    }

    public Courier Closest(String location) {
        Instant earliest = Instant.MAX;
        Courier closest = null;
        for (Courier c : this.Couriers) {
            Instant i = c.GetTimeWhenNextFree();
            if (!i.isBefore(earliest)) continue;
            i = earliest;
            closest = c;
        }
        return closest;
    }

    public CourierBooking MakeBooking(String shippingRef, String origin, String destination, double weight) {
        Courier closestCourier = this.Closest(origin);
        IGoogleRoute route = this.mapApi.GetRoute(origin, destination);
        if (route.GetStatus() != "OK") {
            throw new IllegalArgumentException("Route not found: " + route.GetStatus());
        }
        CourierBooking newBooking = new CourierBooking(weight, route, this.fareCalculator, this.premiumCalculator);
        closestCourier.TakeBooking(newBooking);
        newBooking.ShippingRef = shippingRef;
        return newBooking;
    }
}

