/*
 * Decompiled with CFR 0.152.
 */
package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.CourierManager.HazardType;
import com.kpl.CourierMgmt.CourierManager.IFareCalculator;
import com.kpl.CourierMgmt.CourierManager.IPremiumCalculator;
import com.kpl.CourierMgmt.GoogleMapClient.IGoogleRoute;
import java.time.Duration;
import java.time.Instant;

public class CourierBooking {
    public static Duration PickupWaitingTime = Duration.ofMinutes(5L);
    public static Duration DropOffWaitingTime = Duration.ofMinutes(5L);
    private IFareCalculator journeyPricer;
    private IPremiumCalculator premiumCalculator;
    public IGoogleRoute Route;
    public double Weight;
    public String ShippingRef;
    public Instant EstimatedPickupTime;
    public IGoogleRoute PickupRoute;
    public HazardType PackageHazardType;
    public int PackageValue;

    public String GetOrigin() {
        return this.Route.GetOrigin();
    }

    public String GetDestination() {
        return this.Route.GetDestination();
    }

    public double GetDistance() {
        return this.Route.GetDistance();
    }

    public Instant GetEstimatedDropOffTime() {
        return this.EstimatedPickupTime.plus(PickupWaitingTime).plus(this.Route.GetDuration());
    }

    public CourierBooking(double weight, IGoogleRoute route, IFareCalculator fc) {
        this.init(weight, route, fc, null);
    }

    public CourierBooking(double weight, IGoogleRoute route, IFareCalculator fc, IPremiumCalculator pc) {
        this.init(weight, route, fc, pc);
    }

    private void init(double weight, IGoogleRoute route, IFareCalculator fc, IPremiumCalculator pc) {
        this.journeyPricer = fc;
        this.premiumCalculator = pc;
        this.Weight = weight;
        this.Route = route;
        this.PackageValue = 0;
        this.PackageHazardType = HazardType.NonHazardous;
    }

    public int GetFare() {
        int fare = this.journeyPricer.CalculateFare(this.GetDistance(), this.Weight);
        if (this.premiumCalculator != null) {
            fare += this.premiumCalculator.CalculatePremium(this.PackageHazardType, this.PackageValue, this.GetDistance(), this.Weight);
        }
        return fare;
    }
}

