/*
 * Decompiled with CFR 0.152.
 */
package com.kpl.CourierMgmt.CourierManager;

import com.kpl.CourierMgmt.CourierManager.HazardType;
import com.kpl.CourierMgmt.CourierManager.IPremiumCalculator;

public class BasicPremiumCalculator
implements IPremiumCalculator {
    @Override
    public int CalculatePremium(HazardType hazardType, int packageValue, double distance, double weight) {
        if (packageValue < 0) {
            throw new IllegalArgumentException("Package cannot have a negative value");
        }
        if (distance <= 0.0 || weight <= 0.0) {
            throw new IllegalArgumentException("Package must have a realistic weight and journey distance");
        }
        int premium = 0;
        if (packageValue >= 10000) {
            premium = (int)(0.5 + (double)packageValue * 0.03);
        }
        if (hazardType != HazardType.NonHazardous) {
            premium += 1000 + (int)(0.5 + 100.0 * distance * weight);
        }
        return premium;
    }
}

