﻿using System;

namespace GoogleMapClient
{
    /// <summary>
    /// Interface representing a route between two addresses
    /// as returned by the Google mapping APIs
    /// </summary>

    public interface IGoogleRoute
    {
        /// <summary>
        /// Error code. "OK" if valid route found. Other if not.
        /// </summary>

        string Status { get; }

        /// <summary>
        /// The starting point for the journey, as
        /// normalised and filled in by Google maps
        /// </summary>

        string Origin { get; }

        /// <summary>
        /// The destination for the journey, as
        /// normalised and filled in by Google maps
        /// </summary>

        string Destination { get; }

        /// <summary>
        /// Total route distance between origin
        /// and destination in kilometres
        /// </summary>

        double Distance { get; }

        /// <summary>
        /// The anticipated duration of the journey
        /// if it were to be carries out right now
        /// </summary>

        TimeSpan Duration { get; }
    }
}