﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;

using CourierManager;

namespace WebApiSol.Controllers
{
     [Route("api/[controller]")]
    public class CourierServiceController : Controller
    {
        [HttpGet]
        public IEnumerable<BookingSummary> GetAllBookings()
        {
            try
            {
                return SchedulerFactory.Singleton.BookingSummaries;
            }
            catch(Exception x)
            {
                return new List<BookingSummary>
                {
                    new BookingSummary { Status = x.Message }
                };
            }
        }

        [HttpPost]
        public BookingSummary MakeBooking([FromBody]BookingRequest br)
        {
            try
            {
                var booking = SchedulerFactory.Singleton.MakeBooking(br.ShippingRef, br.Origin, br.Destination, br.Weight);
                return SchedulerFactory.Singleton.DetailsFromBooking(booking);
            }
            catch(Exception x)
            {
                return new BookingSummary { Status = x.Message };
            }
        }
    }
}
