﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GoogleMapClient
{
    /// <summary>
    /// Create a route in the absence of a real google mapping API
    /// </summary>

    public class FakeDirectionsApi : IGoogleMapApi
    {
        public IGoogleRoute GetRoute(string origin, string destination)
        {
            if (string.IsNullOrWhiteSpace(origin))
                throw new ArgumentException("Route origin is empty");
            if (string.IsNullOrWhiteSpace(destination))
                throw new ArgumentException("Route destination is empty");

            // Deal with the zero distance journey

            if (string.Compare(origin, destination, true) == 0)
                return new GoogleRoute
                {
                    Status = "OK",
                    Destination = destination,
                    Origin = origin,
                    Distance = 0,
                    Duration = TimeSpan.Zero,
                };

            // Synthesised journeys for differing origins and destinations.

            return new GoogleRoute
            {
                Status = "OK",
                Destination = destination,
                Origin = origin,
                Distance = 5,
                Duration = TimeSpan.FromMinutes(10)
            };
        }
    }
}
