﻿using System;
using System.Collections.Generic;
using System.Text;
using GoogleMapClient;

namespace CourierManager
{
    public class SchedulerFactory : ISchedulerFactory
    {
        /// <summary>
        /// Receives the application-specific configuration data, usually
        /// passed in from the command line or from a configuration file.
        /// </summary>

        public static string Configuration { get; set; }

        public Scheduler CreateScheduler(IGoogleMapApi gma, IFareCalculator fc, IPremiumCalculator pc)
        {
            return new Scheduler(gma, fc, pc);
        }

        public Scheduler CreateScheduler(IGoogleMapApi gma)
        {
            return CreateScheduler(gma, new BasicFareCalculator(), new BasicPremiumCalculator());
        }

        /// <summary>
        ///  Construct a scheduler for use in the live application. Includes
        ///  a sample set of three couriers.
        /// </summary>
        /// <returns>An end to end scheduler using true Google maps</returns>

        public Scheduler CreateScheduler()
        {
            Scheduler sch;
            if (string.Compare(Configuration, "fake", true) == 0)
                sch = CreateScheduler(new FakeDirectionsApi());
            else
                sch = CreateScheduler(new DirectionsApi("AIzaSyAQiYSiDOkvUbcDuPMAbTVHPd_mhGYKuBM"));

            sch.AddCourier("Rapid Roger", "Westminster Bridge, London");
            sch.AddCourier("Lightning Larry", "Waterloo Station, London");
            sch.AddCourier("Agile Agatha", "Piccadilly Circus, London");
            return sch;
        }

        private static Scheduler theScheduler = null;

        /// <summary>
        /// A singleton implementation for use in 'hasty'
        /// implementations!
        /// </summary>

        public static Scheduler Singleton
        {
            get
            {
                if (theScheduler == null)
                    theScheduler = new SchedulerFactory().CreateScheduler();
                return theScheduler;
            }
        }
    }
}
