﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Serialization;

namespace CourierManager
{
    public class IdentityAllocator
    {
        private ObjectIDGenerator idGenerator;

        private IdentityAllocator()
        {
            idGenerator = new ObjectIDGenerator();
        }

        public long IdentityOf(object t)
        {
            bool firstTime;
            return idGenerator.GetId(t, out firstTime);
        }

        // Singleton implementation

        private static IdentityAllocator theAllocator;

        public static IdentityAllocator Instance
        {
            get
            {
                if (theAllocator == null)
                    theAllocator = new IdentityAllocator();
                return theAllocator;
            }
        }
    }
}
