﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CourierManager
{
    public enum HazardType
    {
        NonHazardous = 0,
        Biological,
        Corrosive,
        Flammable
    }

    /// <summary>
    /// Given a hazardous or valuable item, calculate the premium
    /// to be applied when using a courier to deliver the package
    /// </summary>

    public interface IPremiumCalculator
    {
        /// <summary>
        /// Calculate the premium to be applied to the shipment
        /// of a valuable or hazardous item
        /// </summary>
        /// <param name="hazardType">The nature of hazard this package has</param>
        /// <param name="packageValue">The monetary value of the package</param>
        /// <param name="distance">The distance the package is being carried</param>
        /// <param name="weight">The weight of the package</param>
        /// <returns>The extra sum to pay to have this package delivered, over
        /// and above the basic shipping cost</returns>

        int CalculatePremium(HazardType hazardType, int packageValue, double distance, double weight);
    }
}
