﻿namespace CourierManager
{
    public interface IFareCalculator
    {
        /// <summary>
        /// Given a distance in kilometres a parcel has to be carried, and the
        /// weight of the parcel in kilograms, calculate the fare to be paid
        /// </summary>
        /// <param name="distance">Journey distance in kilometres</param>
        /// <param name="weight">Package weight in kilograms</param>
        /// <returns>The fare to be tendered in pence/cents</returns>

        int CalculateFare(double distance, double weight);
    }
}