﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CourierManager
{
    public class BasicFareCalculator : IFareCalculator
    {
        //public int CalculateFare(double distance, double weight)
        //{
        //    if (distance * weight <= 0)
        //        throw new ArgumentException("Journey distance and weight cannot be negative or zero");

        //    int price = (int)(Math.Ceiling(distance) * Math.Ceiling(weight) * 100);
        //    if (price < 1500)
        //        price = 1500;
        //    return price;
        //}

        public int CalculateFare(double distance, double weight)
        {
            if (distance <= 0)
                throw new ArgumentException("Journey distance negative or zero");
            if (weight <= 0)
                throw new ArgumentException("Weight is negative or zero");

            int price = (int)(Math.Ceiling(distance) * Math.Ceiling(weight) * 100);
            if (price < 1500)
                price = 1500;
            return price;
        }
    }
}
